/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.editor;

import com.quantumdata.fmteditor.editor.UnitPair;
import com.quantumdata.fmteditor.fmt.CmdValue;
import com.quantumdata.fmteditor.fmt.CmdValueListener;
import com.quantumdata.fmteditor.fmt.CmdValueType;
import com.quantumdata.fmteditor.fmt.Format;
import javax.swing.JTextField;

public class BackPorchHandler
implements CmdValueListener {
    private Format m_fmt;
    private JTextField m_label;
    private UnitPair m_horzPair;
    private UnitPair m_vertPair;
    private CmdValue m_prat;
    private CmdValue m_horzBp;
    private CmdValue m_horzBpTime;
    private CmdValue m_vertBp;
    private CmdValue m_vertBpTime;
    private CmdValue[] m_origValues = new CmdValue[4];

    public BackPorchHandler(Format format, JTextField jTextField, UnitPair unitPair, UnitPair unitPair2, CmdValue cmdValue) {
        this.m_fmt = format;
        this.m_horzPair = unitPair;
        this.m_vertPair = unitPair2;
        this.m_label = jTextField;
        this.m_prat = cmdValue;
        this.m_horzBp = new CmdValue(CmdValueType.INT, "HBP", 0.0, "");
        this.m_horzBpTime = new CmdValue(CmdValueType.DOUBLE, "HBPT", 0.0, "");
        this.m_vertBp = new CmdValue(CmdValueType.INT, "VBP", 0.0, "");
        this.m_vertBpTime = new CmdValue(CmdValueType.DOUBLE, "VBPT", 0.0, "");
        this.m_origValues[0] = unitPair.primaryField().getValue();
        this.m_origValues[1] = unitPair.timeField().getValue();
        this.m_origValues[2] = unitPair2.primaryField().getValue();
        this.m_origValues[3] = unitPair2.timeField().getValue();
        this.m_horzBp.addListener(this);
        this.m_vertBp.addListener(this);
    }

    public void valueChanged(CmdValue cmdValue) {
        if (cmdValue.getName().equals("HBP")) {
            this.updateHorz();
        } else {
            this.updateVert();
        }
    }

    public void enable(boolean bl) {
        if (bl) {
            this.m_label.setText("Back Porch");
            this.m_horzPair.setPair(this.m_horzBp, this.m_horzBpTime);
            this.m_vertPair.setPair(this.m_vertBp, this.m_vertBpTime);
            int n = this.m_fmt.getValue("HTOT").getInt() - this.m_fmt.getValue("HRES").getInt() - this.m_fmt.getValue("HSPD").getInt() - this.m_fmt.getValue("HSPW").getInt();
            int n2 = this.m_fmt.getValue("VTOT").getInt() - this.m_fmt.getValue("VRES").getInt() - this.m_fmt.getValue("VSPD").getInt() - this.m_fmt.getValue("VSPW").getInt();
            if (this.m_horzPair.primaryField().isEnabled()) {
                this.m_horzBp.setInt(n);
                this.m_vertBp.setInt(n2);
            } else {
                this.m_horzBpTime.setDouble((double)n / this.m_prat.getDouble());
                this.m_vertBpTime.setDouble((double)n2 / this.m_fmt.getValue("HRAT").getDouble());
            }
        } else {
            this.m_label.setText("Pulse Delay");
            this.m_horzPair.setPair(this.m_origValues[0], this.m_origValues[1]);
            this.m_vertPair.setPair(this.m_origValues[2], this.m_origValues[3]);
        }
    }

    private void updateHorz() {
        int n = this.m_fmt.getValue("HTOT").getInt() - this.m_fmt.getValue("HRES").getInt() - this.m_horzBp.getInt() - this.m_fmt.getValue("HSPW").getInt();
        this.m_origValues[0].setInt(n);
        this.m_origValues[1].setDouble((double)n / this.m_prat.getDouble());
    }

    private void updateVert() {
        int n = this.m_fmt.getValue("VTOT").getInt() - this.m_fmt.getValue("VRES").getInt() - this.m_vertBp.getInt() - this.m_fmt.getValue("VSPW").getInt();
        this.m_origValues[2].setInt(n);
        this.m_origValues[3].setDouble((double)n / this.m_fmt.getValue("HRAT").getDouble());
    }
}

